/*{
	"GUID":"04E1E803-CB09-49cf-91C9-071B1BF67315"
}*/


#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc);
}
//This sketch algorithm is our own inverted method of sketch
//Sketch
__kernel void MAIN(__read_only image2d_t input1, 
	__write_only image2d_t dest_data,
	__global FilterParam* param,
	int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (float2)(0.5f)) / (float2)(W,H);
	
	vec2 offset[9] = 
                { 
                        (vec2)(-1.0f/W, -1.0f/H), 
                        (vec2)(0.0f, -1.0f/H), 
                        (vec2)(1.0f/W, -1.0f/H), 
                        (vec2)(-1.0f/W,    0.0f), 
                        (vec2)(0.0f,    0.0f), 
                        (vec2)(1.0f/W,    0.0f), 
                        (vec2)(-1.0f/W,  1.0f/H), 
                        (vec2)(0.0f,  1.0f/H), 
                        (vec2)(1.0f/W,  1.0f/H)
                };
				
	 vec4 tempColor;   
	 float sample[9];
	 float maxGray = 0.0f;
	 for(int i=0; i < 9; i++)
	 {
		tempColor = INPUTSRC(input1, param, tc + offset[i]* W /640.0f);
		sample[i] = dot(tempColor.xyz, (vec3)(0.114f, 0.587f, 0.299f));
		maxGray = fmax(sample[i], maxGray);
	 }
  
  	
	float fAlpha = (float)alpha/100.0f;
	float4 tuneColor = (vec4)((vec3)(sample[4]/maxGray),1.0f) ;
	float4 origColor = INPUTSRC(input1, param, tc);
	float4 outputColor = tuneColor * fAlpha + origColor * (1.0f - fAlpha);
	
  write_imagef( dest_data, coordinate, outputColor );
}
